function [matrix,M]=assemStokes(dcdx,dedx,dcdy,dedy,detjac,gradgrad,...
    vertices,elements,nln_u,nln_p,pl,nov,nov_v,nov_p,noe,DIVX,DIVY,...
    diffusion,rho,l1,l2,MASSA)
% Matrices with viscosity and density piecewise constant.
tic
C11r=zeros(nln_u*nln_u*noe,1);
C11c=zeros(nln_u*nln_u*noe,1);
C11e=zeros(nln_u*nln_u*noe,1);
C22e=zeros(nln_u*nln_u*noe,1);
C12e=zeros(nln_u*nln_u*noe,1);
Me=zeros(nln_u*nln_u*noe,1);
Gr=zeros(2*nln_u*nln_p*noe,1);
Gc=zeros(2*nln_u*nln_p*noe,1);
Ge=zeros(2*nln_u*nln_p*noe,1);

aloc1 = [diffusion.*dcdx.^2; ...
         diffusion.*dedx.^2; ...
         diffusion.*dcdx.*dedx; ...
         diffusion.*dedx.*dcdx]'*gradgrad;
aloc2 = [diffusion.*dcdy.^2; ...
         diffusion.*dedy.^2; ...
         diffusion.*dcdy.*dedy; ...
         diffusion.*dedy.*dcdy]'*gradgrad;
aloc3 = [diffusion.*dcdx.*dcdy; ...
         diffusion.*dedx.*dedy; ...
         diffusion.*dcdx.*dedy; ...
         diffusion.*dedx.*dcdy]'*gradgrad;
DIVX = DIVX'; 
DIVY=DIVY';
div = [DIVX(:)'; DIVY(:)'];
alocG1 = [dcdx;dedx]'*div;
alocG2 = [dcdy;dedy]'*div;

indicir=repmat([1:nln_u]',nln_u,1);   
indicirG=repmat([1:nln_u]',nln_p,1); 
indicic=[];
indicicG=[];
for ic=1:nln_u
    indicic=[indicic;ic*ones(nln_u,1)];
end
for icG=1:nln_p
    indicicG=[indicicG;icG*ones(nln_u,1)];
end



iii=[1:nln_u*nln_u];
iiiG=[1:nln_u*nln_p];
%keyboard
for ie = 1:noe   
    local1 = [];
    local2 = [];
    local3 = [];
    localgrad1=[];
    localgrad2=[];
    for j = 1:nln_u
        local1 = [local1; aloc1(ie,l1(j):l2(j))];
        local2 = [local2; aloc2(ie,l1(j):l2(j))];
        local3 = [local3; aloc3(ie,l1(j):l2(j))];
        localgrad1 = [localgrad1; alocG1(ie,pl(j,:))];
        localgrad2 = [localgrad2; alocG2(ie,pl(j,:))];
    end
    C11r(iii)=elements(indicir,ie);
    C11c(iii)=elements(indicic,ie);
    C11e(iii)=(2*local1(:)+local2(:))*detjac(ie);
    C22e(iii)=(local1(:)+2*local2(:))*detjac(ie);
    C12e(iii)=local3(:)*detjac(ie);
    Me(iii)=MASSA(:)*detjac(ie)*rho(ie);
    Gr(iiiG)=elements(indicirG,ie);
    Gc(iiiG)=elements(indicicG,ie);
    Ge(iiiG)=localgrad1(:)*detjac(ie);
    Gr(iiiG+nln_u*nln_p*noe)=elements(indicirG,ie)+nov;
    Gc(iiiG+nln_u*nln_p*noe)=elements(indicicG,ie);
    Ge(iiiG+nln_u*nln_p*noe)=localgrad2(:)*detjac(ie);
    iii=iii+nln_u*nln_u;
    iiiG=iiiG+nln_u*nln_p;
end 
%keyboard
M=sparse(C11r,C11c,Me,nov,nov);
tic
matrix=sparse([C11r;C11r;C11c+nov;C11r+nov;Gr;Gc+2*nov],[C11c;C11c+nov;C11r;C11c+nov;Gc+2*nov;Gr],[C11e;C12e;C12e;C22e;Ge;-Ge]);
toc

return
